<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('customs')) {
            Schema::create('customs', function (Blueprint $table) {
                $table->id();
                $table->string('number')->nullable();
                $table->string('accd_number')->nullable();
				$table->string('vehicle_number')->nullable();
				$table->text('description')->nullable();
                $table->datetime('date')->nullable();
                $table->string('type')->nullable();
                $table->double('qty')->nullable();
                $table->string('currency')->nullable();
                $table->double('item_value')->nullable();
				$table->integer('item_id')->unsigned()->nullable();
				$table->integer('um_id')->unsigned()->nullable();
                $table->integer('foreign_data_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs');
    }
}
