<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddGrandFatherNameToMemberInformationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('member_informations', function (Blueprint $table) {
             if (!Schema::hasColumn('member_informations','grand_father_name')){
				$table->string('grand_father_name')->nullable();
				$table->string('current_location')->nullable();
				$table->string('main_location')->nullable();
				$table->string('national_number')->nullable();
				$table->string('national_volume')->nullable();
				$table->string('national_page')->nullable();
				$table->string('national_reg_number')->nullable();
                $table->string('introduced_by')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('member_informations', function (Blueprint $table) {
            //
        });
    }
}
