<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDriverIdToCargoLoadingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cargo_loadings', function (Blueprint $table) {
            if (!Schema::hasColumn('cargo_loadings', 'source_id')) {
				$table->integer('source_id')->unsigned()->nullable();
				$table->integer('driver_id')->unsigned()->nullable();
                $table->integer('vehicle_id')->unsigned()->nullable();
                $table->integer('container_id')->unsigned()->nullable();
                $table->string('other_driver_name')->nullable();
                $table->string('other_vehicle_name')->nullable();
                $table->string('driver_type')->nullable();
                $table->string('state')->nullable();
                $table->string('source')->nullable();
                $table->string('destination')->nullable();
                $table->string('transit_number')->nullable();
                $table->string('cmr_number')->nullable();
                $table->integer('parent_id')->nullable();
                $table->integer('user_id' )->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cargo_loadings', function (Blueprint $table) {
            //
        });
    }
}
