<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWeighbridgesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('weighbridges')) {
            Schema::create('weighbridges', function (Blueprint $table) {
                $table->id();
                $table->string('number')->nullable();
				$table->string('vehicle_number')->nullable();
				$table->string('driver_name')->nullable();
                $table->text('description')->nullable();
                $table->datetime('date')->nullable();
                $table->time('hour')->nullable();
                $table->string('type')->nullable();
                $table->double('empty_weight')->nullable();
                $table->double('net_weight')->nullable();
                $table->double('full_weight')->nullable();
				$table->integer('item_id')->unsigned()->nullable();
                $table->integer('um_id')->unsigned()->nullable();
                $table->integer('foreign_data_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('weighbridges');
    }
}
