<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLaboratoryDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('laboratory_details')) {
			Schema::create('laboratory_details', function (Blueprint $table) {
				$table->id();
				$table->string('qty')->nullable();
				$table->text('description')->nullable();
				$table->integer('laboratory_id')->unsigned()->nullable();
				$table->integer('laboratory_test_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('laboratory_details');
    }
}
