<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInstallmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('installments')) {

            Schema::create('installments', function (Blueprint $table) {
                $table->id();
                $table->text('description')->nullable();
                $table->datetime('date')->nullable();
                $table->double('amount')->nullable();
                $table->string('currency');
                $table->string('status')->nullable();
                $table->integer('sale_id')->unsigned();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('installments');
    }
}
