<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExchangeBrokerChequesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('exchange_broker_cheques')) {
			Schema::create('exchange_broker_cheques', function (Blueprint $table) {
				$table->id();
				$table->integer('exchange_broker_id');
				$table->integer('exchange_broker_detail_id');
				$table->integer('from_member_id')->nullable();
				$table->integer('from_pay_transaction_id')->nullable();
				$table->integer('from_rec_transaction_id')->nullable();
				$table->integer('to_member_id')->nullable();
				$table->integer('to_pay_transaction_id')->nullable();
				$table->integer('to_rec_transaction_id')->nullable();
				$table->integer('account_transaction_id')->nullable();
				$table->integer('income_transaction_id')->nullable();
				$table->integer('member_exp_transaction_id')->nullable();
				$table->integer('exp_member_id')->nullable();
				$table->string('card_owner')->nullable();
				$table->string('card_number')->nullable();
				$table->string('tracking_number')->nullable();
				$table->string('shaba_number')->nullable();
				$table->double('amount')->nullable();
				$table->string('from_currency')->nullable();
				$table->double('from_rate')->nullable();
				$table->string('to_currency')->nullable();
				$table->double('to_rate')->nullable();
				$table->datetime('date')->nullable();
				$table->string('status')->nullable();
				$table->text('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exchange_broker_cheques');
    }
}
