<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExchangeBrokerDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('exchange_broker_details')) {
			Schema::create('exchange_broker_details', function (Blueprint $table) {
				$table->id();
				$table->integer('exchange_broker_id');
				$table->integer('buyer_id');
				$table->double('amount')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->text('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exchange_broker_details');
    }
}
