<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExchangeBrokersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('exchange_brokers')) {
			Schema::create('exchange_brokers', function (Blueprint $table) {
				$table->id();
				$table->integer('saler_id');
				$table->integer('number')->nullable();
				$table->string('type')->nullable();
				$table->double('amount')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->string('ex_currency')->nullable();
				$table->double('ex_rate')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('due_date')->nullable();
				$table->string('commission_type')->nullable();
				$table->integer('commission_bank_tran_id')->nullable();
				$table->integer('commission_income_tran_id')->nullable();
				$table->integer('commission_recievable_tran_id')->nullable();
				$table->double('commission_amount')->nullable();
				$table->string('select_commiss_currency')->nullable();
				$table->integer('class_id')->nullable();
				$table->text('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exchange_brokers');
    }
}
