<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            if(!Schema::hasColumn('projects','status'))
            {
                $table->string('status')->nullable();
                $table->double('grantee_amount')->nullable();
				$table->integer('volunteeres')->nullable();
				$table->datetime('volunteering_date')->nullable();
				$table->integer('employee_id')->unsigned()->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            //
        });
    }
}
