<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectVolunteeresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('project_volunteeres')) {
			Schema::create('project_volunteeres', function (Blueprint $table) {
				$table->id();
				$table->integer('project_id')->unsigned()->nullable();
                $table->string('name')->nullable();
                $table->double('price')->nullable();
				$table->double('discount')->nullable();
				$table->string('type')->nullable();
				$table->text('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_volunteeres');
    }
}
