<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToDailyExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('daily_expenses', function (Blueprint $table) {
            if(!Schema::hasColumn('daily_expenses','status'))
            {
                $table->string('status')->nullable();
            }
        });
		
		Schema::table('expenses', function (Blueprint $table) {
			if(Schema::hasColumn('expenses','status')){
				$table->string('status')->nullable()->change();
			}
        });
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('daily_expenses', function (Blueprint $table) {
            //
        });
    }
}
