<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoLoadingDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_loading_details')) {
			Schema::create('cargo_loading_details', function (Blueprint $table) {
				$table->id();
				$table->integer('cargo_loading_id')->unsigned()->nullable();
				$table->integer('cargo_contract_id')->unsigned()->nullable();
                $table->integer('driver_id')->unsigned()->nullable();
                $table->integer('vehicle_id')->unsigned()->nullable();
                $table->integer('container_id')->unsigned()->nullable();
                $table->string('other_driver_name')->nullable();
                $table->string('other_vehicle_name')->nullable();
                $table->string('driver_type')->nullable();
                $table->string('state')->nullable();
                $table->string('source')->nullable();
                $table->string('destination')->nullable();
                $table->string('transit_number')->nullable();
                $table->string('cmr_number')->nullable();
                $table->integer('cargo_item_id')->unsigned();
                $table->integer('site_id')->unsigned()->nullable();
                $table->double('quantity')->nullable();
                $table->datetime('loading_date');
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_loading_details');
    }
}
