<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoLoadingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_loadings')) {
			Schema::create('cargo_loadings', function (Blueprint $table) {
				$table->id();
				$table->integer('number')->nullable();
				$table->string('type');
				$table->datetime('date');
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_loadings');
    }
}
