<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_stocks')) {
			Schema::create('cargo_stocks', function (Blueprint $table) {
				$table->id();
				$table->integer('cargo_item_id')->unsigned();
				$table->integer('cargo_contract_id')->unsigned()->nullable();
				$table->integer('cargo_loading_id')->unsigned()->nullable();
				$table->datetime('date_in')->nullable();
				$table->double('weight')->nullable();
				$table->double('volume')->nullable();
				$table->double('quantity')->nullable();
				$table->double('price')->nullable();
				$table->integer('site_id')->unsigned()->nullable();
				$table->text('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_stocks');
    }
}
