<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangePercentageToCloseYearsEquityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('close_years_equity', function (Blueprint $table) {
			if(Schema::hasColumn('close_years_equity','last_percentage')){
				$table->float('last_percentage',4,4)->nullable()->change();
			}
			if(Schema::hasColumn('close_years_equity','new_percentage')){
				$table->float('new_percentage',4,4)->nullable()->change();
			}
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('close_years_equity', function (Blueprint $table) {
            //
        });
    }
}
