<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoItemExpenseDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_item_expense_details')) {
            Schema::create('cargo_item_expense_details', function (Blueprint $table) {
                $table->id();
				$table->integer('cargo_item_expense_id')->nullable();
				$table->text('description')->nullable();
				$table->double('amount')->nullable();
				$table->integer('transaction_id')->nullable();
				$table->string('type')->nullable();
				$table->integer('type_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_item_expense_details');
    }
}
