<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoItemExpenseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_item_expense')) {
            Schema::create('cargo_item_expense', function (Blueprint $table) {
                $table->id();
				$table->string('number')->nullable();
				$table->integer('member_id')->nullable();
				$table->string('expense_type')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->integer('bank_tran_id')->nullable();
				$table->integer('expense_tran_id')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_item_expense');
    }
}
