<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoContractTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_contract')) {
            Schema::create('cargo_contract', function (Blueprint $table) {
                $table->id();
				$table->integer('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->integer('member_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->integer('transaction_id')->nullable();
				$table->string('discount_type')->nullable();
				$table->double('discount')->nullable();
				$table->integer('discount_transaction_id')->nullable();
				$table->integer('income_id')->nullable();
				$table->integer('expense_id')->nullable();
				$table->string('status')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('delivery_date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }
	
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_contract');
    }
}
