<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePriceListDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('price_list_details')) {
            Schema::create('price_list_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('destination_id')->nullable();
				$table->double('amount')->nullable();
				$table->integer('price_list_amount_id')->nullable();
				$table->integer('price_list_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('price_list_details');
    }
}
