<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMonetarySourceToCurrencyExchangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('currency_exchanges', function (Blueprint $table) {
            if(!Schema::hasColumn('currency_exchanges','monetary_source'))
            {
                $table->string('monetary_source')->nullable();
            }
        });
		
		Schema::table('cheque', function (Blueprint $table) {
            if(!Schema::hasColumn('cheque','monetary_source'))
            {
                $table->string('monetary_source')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('currency_exchanges', function (Blueprint $table) {
            //
        });
    }
}
