<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccountClassTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('account_class')) {
            Schema::create('account_class', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('name')->nullable();
				$table->string('description')->nullable();
				$table->integer('status')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
		
		Schema::table('accounts', function (Blueprint $table) {
            if(!Schema::hasColumn('accounts','class_id')){
                $table->integer('class_id')->unsigned()->nullable();
            }
        });
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_class');
    }
}
