<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSaleStatusToSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sales', function (Blueprint $table) {
            if(!Schema::hasColumn('sales','sale_status'))
            {
                $table->string('sale_status')->nullable();
            }
        });
		
        Schema::table('sale_infos', function (Blueprint $table) {
            if(!Schema::hasColumn('sale_infos','user_id'))
            {
                $table->integer('user_id')->nullable();
            }
        });
		
        Schema::table('sale_services', function (Blueprint $table) {
            if(!Schema::hasColumn('sale_services','user_id'))
            {
                $table->integer('user_id')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sales', function (Blueprint $table) {
            //
        });
    }
}
