<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWashingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('washing')) {
            Schema::create('washing', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('sale_id')->unsigned()->nullable();
                $table->string('carpet_type')->nullable();
                $table->double('length')->nullable();
                $table->double('width')->nullable();
                $table->string('washing_company_number')->nullable();
                $table->string('company_number')->nullable();
                $table->datetime('date_in')->nullable();
                $table->datetime('delivery_date')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('washing');
    }
}
