<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChequeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cheque')) {
            Schema::create('cheque', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->string('type')->nullable();
				$table->string('status')->nullable();
				$table->string('sender')->nullable();
				$table->integer('sender_id')->nullable();
				$table->string('sen_ssn_number')->nullable();
				$table->string('reciever')->nullable();
				$table->integer('reciever_id')->nullable();
				$table->string('rec_ssn_number')->nullable();
				$table->integer('account_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->integer('bank_transaction_id')->nullable();
				$table->integer('cheque_transaction_id')->nullable();
				$table->string('transaction_type')->nullable();
				$table->string('commission_type')->nullable();
				$table->integer('commission_income_tran_id')->nullable();
				$table->integer('commission_bank_tran_id')->nullable();
				$table->integer('commission_recievable_tran_id')->nullable();
				$table->integer('member_id')->nullable();
				$table->integer('class_id')->nullable();
				$table->text('description')->nullable();
				$table->text('description1')->nullable();
				$table->text('description2')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('due_date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheque');
    }
}
