<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrencyExchangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('currency_exchanges')) {
            Schema::create('currency_exchanges', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->string('type')->nullable();
				$table->integer('sp_account_id')->nullable();
				$table->string('sp_currency')->nullable();
				$table->double('sp_rate')->nullable();
				$table->double('sp_today_rate')->nullable();
				$table->integer('sp_transaction_id')->nullable();
				$table->integer('ex_account_id')->nullable();
				$table->string('ex_currency')->nullable();
				$table->double('ex_rate')->nullable();
				$table->double('ex_today_rate')->nullable();
				$table->integer('ex_transaction_id')->nullable();
				$table->integer('member_id')->nullable();
				$table->integer('income_transaction_id')->nullable();
				$table->integer('COGS_transaction_id')->nullable();
				$table->integer('gain_loss_transaction_id')->nullable();
				$table->text('description')->nullable();
				$table->text('description1')->nullable();
				$table->text('description2')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currency_exchanges');
    }
}
