<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleCommissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('sale_commissions')) {
            Schema::create('sale_commissions', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('commission_id')->unsigned();
                $table->integer('sale_id')->unsigned()->nullable();
                $table->integer('sale_info_id')->unsigned()->nullable();
                $table->integer('vendor_id')->unsigned()->nullable();
                $table->integer('vendor_transaction_id')->unsigned()->nullable();
                $table->integer('customer_id')->unsigned()->nullable();
                $table->integer('customer_transaction_id')->unsigned()->nullable();
                $table->datetime('date')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_commissions');
    }
}
