<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFixAssetSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('fix_asset_sales')) {
            Schema::create('fix_asset_sales', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('fixed_asset_id')->nullable();
				$table->string('number')->nullable();
				$table->datetime('date')->nullable();
				$table->text('description')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->double('amount',27, 8)->nullable();
				$table->string('receive_type')->nullable();
				$table->integer('customer_id')->nullable();
				$table->integer('expense_id')->nullable();
				$table->integer('income_id')->nullable();
				$table->integer('asset_transaction_id')->nullable();
				$table->integer('expense_transaction_id')->nullable();
				$table->integer('receivable_transaction_id')->nullable();
				$table->integer('bank_transaction_id')->nullable();
				$table->integer('income_transaction_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fix_asset_sales');
    }
}
