<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBankTransactionIdToFixedAssetManagementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('fixed_asset_management', function (Blueprint $table) {
            if(!Schema::hasColumn('fixed_asset_management','bank_transaction_id')){
				$table->integer('bank_transaction_id')->nullable();
				$table->integer('payable_transaction_id')->nullable();
				$table->string('payment_type')->nullable();
				$table->string('buy_check')->nullable();
				$table->string('depreciation_type')->nullable();
				$table->string('depreciation_duration_type')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fixed_asset_management', function (Blueprint $table) {
            //
        });
    }
}
