<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCarpetContractDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('carpet_contract_details')) {
            Schema::create('carpet_contract_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('carpet_contract_id')->nullable();
				$table->integer('inventory_id')->nullable();
				$table->integer('site_id')->nullable();
				$table->double('quantity')->nullable();
				$table->integer('um_id')->nullable();
				$table->integer('um1_id')->nullable();
				$table->integer('um2_id')->nullable();
				$table->integer('um3_id')->nullable();
				$table->double('other_measure1')->nullable();
				$table->double('other_measure2')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carpet_contract_details');
    }
}
