<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCarpetContractsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('carpet_contracts')) {
            Schema::create('carpet_contracts', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->integer('customer_id')->nullable();
				$table->string('graph_number')->nullable();
				$table->string('quality')->nullable();
				$table->string('size')->nullable();
				$table->string('text_map')->nullable();
				$table->string('border_map')->nullable();
				$table->string('duration')->nullable();
				$table->string('work_type')->nullable();
				$table->string('status')->nullable();
				$table->double('price_level1')->nullable();
				$table->double('price_level2')->nullable();
				$table->double('price_level3')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->default(1);
				$table->datetime('date')->nullable();
				$table->datetime('start_date')->nullable();
				$table->datetime('end_date')->nullable();
				$table->text('description')->nullable();
				$table->text('memo')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carpet_contracts');
    }
}
