<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDriverInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('driver_info')) {
            Schema::create('driver_info', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('cus_delivery_item_id')->nullable();
				$table->string('name')->nullable();
				$table->string('palet_number')->nullable();
				$table->string('color')->nullable();
				$table->double('amount')->nullable();
				$table->double('prepaid')->nullable();
				$table->string('source')->nullable();
				$table->string('destination')->nullable();
				$table->string('load_place')->nullable();
				$table->string('commissar')->nullable();
				$table->text('description')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('driver_info');
    }
}
