<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerDeliveryItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customer_delivery_items')) {
            Schema::create('customer_delivery_items', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->integer('customer_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->datetime('date')->nullable();
				$table->text('description')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_delivery_items');
    }
}
