<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerStockOutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customer_stock_outs')) {
            Schema::create('customer_stock_outs', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('inventory_id')->nullable();
				$table->integer('stock_id')->nullable();
				$table->integer('site_id')->nullable();
				$table->double('price')->nullable();
				$table->double('qut_out')->nullable();
				$table->integer('um_id')->nullable();
				$table->integer('customer_id')->nullable();
				$table->datetime('date_out')->nullable();
				$table->string('type')->nullable();
				$table->integer('type_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_stock_outs');
    }
}
