<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customer_stocks')) {
            Schema::create('customer_stocks', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('inventory_id')->nullable();
				$table->integer('site_id')->nullable();
				$table->double('cost')->nullable();
				$table->double('qut_in')->nullable();
				$table->integer('customer_id')->nullable();
				$table->datetime('date_in')->nullable();
				$table->string('type')->nullable();
				$table->integer('type_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_stocks');
    }
}
