<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleCMRDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_cmr_details')) {
            Schema::create('vehicle_cmr_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('vehicleCMR_id')->nullable();
				$table->integer('driver_id')->nullable();
				$table->integer('vehicle_id')->nullable();
				$table->double('amount')->nullable();
				$table->integer('transaction_id')->nullable();
				$table->integer('income_transaction_id')->nullable();
				$table->string('source')->nullable();
				$table->string('destination')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_cmr_details');
    }
}
