<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleIntroduceDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_introduce_details')) {
            Schema::create('vehicle_introduce_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('vehicle_intro_id');
				$table->integer('driver_id');
				$table->integer('vehicle_id')->nullable();
				$table->string('road_activity')->nullable();
				$table->string('base_load')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_introduce_details');
    }
}
