<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleIntroducesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_introduces')) {
            Schema::create('vehicle_introduces', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('customer_id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_introduces');
    }
}
