<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('messaging')) {
            Schema::create('messaging', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('session_id');
				$table->integer('user_in_id')->nullable();
				$table->integer('user_out_id')->nullable();
				$table->text('massage')->nullable();
				$table->string('status')->nullable();
				$table->string('type')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messaging');
    }
}
