<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTodoFeedbackTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('todo_feedback')) {
            Schema::create('todo_feedback', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('todo_id')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('parent_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('todo_feedback');
    }
}
