<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTodoListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('todo_list')) {
            Schema::create('todo_list', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->time('time')->nullable();
				$table->string('priority')->nullable();
				$table->string('status')->nullable();
				$table->string('type')->nullable();
				$table->integer('member_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('todo_list');
    }
}
