<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddMemoToSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('sales', function (Blueprint $table) {
            if(!Schema::hasColumn('sales','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('purchases', function (Blueprint $table) {
            if(!Schema::hasColumn('purchases','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('expenses', function (Blueprint $table) {
            if(!Schema::hasColumn('expenses','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('daily_expenses', function (Blueprint $table) {
            if(!Schema::hasColumn('daily_expenses','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('payments', function (Blueprint $table) {
            if(!Schema::hasColumn('payments','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('receivable_payments', function (Blueprint $table) {
            if(!Schema::hasColumn('receivable_payments','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('payment_by_factors', function (Blueprint $table) {
            if(!Schema::hasColumn('payment_by_factors','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('receive_by_factors', function (Blueprint $table) {
            if(!Schema::hasColumn('receive_by_factors','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('sales_orders', function (Blueprint $table) {
            if(!Schema::hasColumn('sales_orders','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('contracts', function (Blueprint $table) {
            if(!Schema::hasColumn('contracts','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('projects', function (Blueprint $table) {
            if(!Schema::hasColumn('projects','memo')){
				$table->text('memo')->nullable();
            }
        });
		Schema::table('purchase_orders', function (Blueprint $table) {
            if(!Schema::hasColumn('purchase_orders','memo')){
				$table->text('memo')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sales', function (Blueprint $table) {
            //
        });
    }
}
