<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCloseYearFixAssetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('close_year_fix_assets')) {
            Schema::create('close_year_fix_assets', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('close_year_id')->nullable();
				$table->integer('fixed_asset_id')->nullable();
				$table->double('amount',27, 8)->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('close_year_fix_assets');
    }
}
