<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFixAssetDepreciationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('fix_asset_depreciation')) {
            Schema::create('fix_asset_depreciation', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('fixed_asset_id')->nullable();
				$table->datetime('date')->nullable();
				$table->text('description')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->double('amount',27, 8)->nullable();
				$table->integer('expense_id')->nullable();
				$table->integer('asset_transaction_id')->nullable();
				$table->integer('expense_transaction_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fix_asset_depreciation');
    }
}
