<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFixedAssetManagementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('fixed_asset_management')) {
            Schema::create('fixed_asset_management', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('name')->nullable();
				$table->string('number')->nullable();
				$table->string('barcode_number')->nullable();
				$table->string('type')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('expire_date')->nullable();
				$table->integer('asset_id')->nullable();
				$table->integer('vendor_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->double('cost',27, 8)->nullable();
				$table->string('location')->nullable();
				$table->string('po_number')->nullable();
				$table->string('serial_number')->nullable();
				$table->string('status')->nullable();
				$table->text('note')->nullable();
				$table->integer('transaction_id')->nullable();
				$table->integer('opening_transaction_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fixed_asset_management');
    }
}
