<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNProOrderReceiveAndPayTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		
		if(!Schema::hasTable('n_pro_order_receive_and_pay')) {
            Schema::create('n_pro_order_receive_and_pay', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('requir_date')->nullable();
				$table->string('pay_type')->nullable();
				$table->integer('bank_account_id')->nullable();
				$table->integer('vendor_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->string('priority')->nullable();
				$table->string('expense_type')->nullable();
				$table->string('type')->nullable();
				$table->string('status')->nullable();
				$table->integer('member_id')->nullable();
				$table->integer('pro_order_id')->nullable();
				$table->integer('ngo_project_id')->nullable();
				$table->integer('transaction_id')->nullable();
				$table->integer('expense_transaction_id')->nullable();
				$table->integer('driver_id')->nullable();
				$table->integer('vehicle_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('n_pro_order_receive_and_pay');
    }
}
