<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleLogBooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_log_books')) {
            Schema::create('vehicle_log_books', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('number')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->string('plate_number')->nullable();
				$table->integer('vehicle_id')->nullable();
				$table->integer('start_period')->nullable();
				$table->integer('end_period')->nullable();
				$table->datetime('start_trip_date')->nullable();
				$table->datetime('end_trip_date')->nullable();
				$table->double('start_odometer')->nullable();
				$table->double('finish_odometer')->nullable();
				$table->double('odometer_value')->nullable();
				$table->string('traveller')->nullable();
				$table->string('driver_signature')->nullable();
				$table->integer('item_id')->nullable();
				$table->integer('driver_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_log_books');
    }
}
