<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNProOrderDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('n_pro_order_details')) {
            Schema::create('n_pro_order_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->double('quantity')->nullable();
				$table->integer('um_id')->nullable();
				$table->string('description')->nullable();
				$table->double('price')->nullable();
				$table->double('purchase_price')->nullable();
				$table->string('payment_term')->nullable();
				$table->string('mode_of_mayment')->nullable();
				$table->integer('pro_order_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('n_pro_order_details');
    }
}
