<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNProOrderCycleMemoesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('n_pro_order_cycle_memoes')) {
            Schema::create('n_pro_order_cycle_memoes', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('type')->nullable();
				$table->string('status')->nullable();
				$table->datetime('date')->nullable();
				$table->text('description')->nullable();
				$table->integer('pro_order_id')->nullable();
				$table->integer('position_id')->nullable();
				$table->integer('parent_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('n_pro_order_cycle_memoes');
    }
}
