<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNgoProjectTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('ngo_projects')) {
            Schema::create('ngo_projects', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('name')->nullable();
				$table->string('code')->nullable();
				$table->string('ref_no')->nullable();
				$table->string('location')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('start_date')->nullable();
				$table->datetime('end_date')->nullable();
				$table->string('status')->nullable();
				$table->integer('category_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ngo_projects');
    }
}
